--************************************************************
-- From CreationIntervFieldDB.xml
--************************************************************
CREATE TABLE dbo.Quota (
[QtStratum] [int] NOT NULL,
	[QtCriterion] [varchar] (7500) NULL,
	[QtLabel] [nvarchar] (4000) NULL,
	[QtQuota] [float] NULL,
	[QtSchedule] [varchar] (5) NULL,
	[QtGroup] [int] NULL,
	[QtWeight] [float] NULL,
	[QtUnused] [float] NULL,
	[QtOnLine] [int] NULL,
	[QtFrequence] [float] NULL,
	[QtPriority] [int] NULL,
	[QtRelative] [float] NULL,
	[QtPeriodic] [float] NULL,
	[QtStatus] [int] NULL,
	[QtStatusTemp] [int] NULL,
	[QtLastUpDate] [datetime] NULL,
	[projectId] [int] NULL ,					
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
Constraint PK_Quota PRIMARY KEY(QtStratum)
)

CREATE INDEX [IxQtSchedule] ON [Quota] ([QtSchedule]) ON [PRIMARY]

CREATE INDEX [IxQtStatus] ON [Quota] ([QtStatus]) ON [PRIMARY]

CREATE INDEX [IxQtStatusTemp] ON [Quota] ([QtStatusTemp]) ON [PRIMARY]

CREATE INDEX [IxQtGroup] ON [Quota] ([QtGroup]) ON [PRIMARY]

CREATE INDEX [IxQtFrequence] ON [Quota] ([QtFrequence]) ON [PRIMARY]

CREATE INDEX [IxQtQuota] ON  [Quota] ([QtQuota]) ON [PRIMARY]

CREATE INDEX [IxQtOnLine] ON [Quota] ([QtOnLine]) ON [PRIMARY]			
GO

	CREATE TABLE dbo.Respondent (
	[ResRespondent] [varchar] (10) NOT NULL,
	[ResLanguage] [int] NULL,
	[ResTimeZone] [int] NULL,
	[ResCallbackDate] [datetime] NULL,
	[ResIntervCall] [nvarchar] (10) NULL,
	[ResTimeSlot] [bit] NULL,
	[ResCallCount] [int] NULL,
	[ResLastCallDate] [datetime] NULL,
	[ResVersion] [varchar] (10) NULL,
	[ResPriority] [int] NULL,
	[ResCompleted] [bit] NULL,
	[ResConfidPhone] [bit] NULL,
	[ResSeed] [float] NULL default Rand(),
	[Resphone] [varchar] (20) NULL,
	[ResCodeResult] [varchar] (2) NULL,
	[ResWaveNo] [int] NULL,
	[ResBlocked] [bit] NULL,
	[ResCompPredictive] [bit] NULL,
	[ResCall] [bit] NULL,
	[ResMonitored] [bit] NULL,
	[ResLastCompQuest] [int] NULL,
	[ResPreviousCallDate] [datetime] NULL,
	[ResWaveImportNo] [int] NULL,
	[projectId] [int] NULL ,
	[collectMode] [int] NULL ,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL,
[panelistId] [int] NULL
	Constraint PK_Respondent PRIMARY KEY(ResRespondent)
	)				
	CREATE INDEX [IxResphone] ON [Respondent] ([Resphone]) ON [PRIMARY]
	CREATE INDEX [IxResIntervCall] ON [Respondent] ([ResIntervCall]) ON [PRIMARY]
	CREATE INDEX [IxResSeed] ON [Respondent] ([ResSeed]) ON [PRIMARY]
CREATE INDEX [IxResPanelistId] ON [Respondent] ([panelistId]) ON [PRIMARY]		
GO

CREATE TABLE [dbo].[RespondentPIN] (
	[RspRespondent] [varchar] (10) NOT NULL ,
	[RspPIN] [nvarchar] (100) NULL ,
	[ProjectId] [int] NULL ,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[RespondentPIN] WITH NOCHECK ADD 
	CONSTRAINT [PK_RespondentPIN] PRIMARY KEY  CLUSTERED 
	(
		[RspRespondent]
	)  ON [PRIMARY] 


ALTER TABLE [dbo].[RespondentPIN] ADD 
	CONSTRAINT [FK_RespondentPIN_Respondent] FOREIGN KEY 
	(
		[RspRespondent]
	) REFERENCES [dbo].[Respondent] (
		[ResRespondent]
	) ON DELETE CASCADE
	
ALTER TABLE [dbo].[RespondentPIN] ADD 
CONSTRAINT [IX_RespondentPIN] UNIQUE  NONCLUSTERED 
(
	[RspPIN]
)  ON [PRIMARY]  
GO

CREATE TABLE [dbo].[MonitoringCfg] (
	[ProjectID] [int] NOT NULL ,
	[NbrInterviewsToMonitor] [int] NULL ,
	[MonitoringType] [int] NULL ,
	[NbrQuestionToCompletInterview] [int] NULL ,
	[MinSessionDuration] [int] NULL ,
	[MaxInterviewsPerDay] [int] NULL,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
) ON [PRIMARY]								

ALTER TABLE [dbo].[MonitoringCfg] WITH NOCHECK ADD 
	CONSTRAINT [PK_MonitoringCfg] PRIMARY KEY  CLUSTERED 
	([ProjectID])  ON [PRIMARY] 				
GO

CREATE TABLE [dbo].[MonitoringCfgQuestionsThatCount] (
	[ProjectID] [int] NOT NULL ,
	[QuestionAlias] [varchar] (5)  NOT NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[MonitoringCfgQuestionsThatCount] WITH NOCHECK ADD 
	CONSTRAINT [PK_MonitoringCfgQuestionsThatCount] PRIMARY KEY  CLUSTERED 
	(
		[ProjectID],
		[QuestionAlias]
	)  ON [PRIMARY] 			
GO

create table dbo.BufferNew (
	Respondent   varchar(10) primary key,
	intgroup   int,
	ResCall      bit default 0,
	NEwDateTime  datetime default getutcdate(),
		CallbackDate datetime default -2,
		Priority int default 1,
		seed float default rand(),
	Phone varchar(20),
	[projectId] [int] NULL 
	)									
GO

CREATE TABLE dbo.TimeSlot (
[TslNumber] [int] NOT NULL,
	[TslWeekDay] [int] NOT NULL,
	[TslStartTime] [datetime] NOT NULL,
	[TslEndTime] [datetime] NOT NULL,
	[TslTimeSlot] [int] NOT NULL,
	[projectId] [int] NULL ,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
Constraint PK_TimeSlot PRIMARY KEY(TslTimeSlot,TslWeekDay,TslStartTime,TslEndTime)
)
GO

CREATE TABLE dbo.Schedule (
[SchNumber] [int] NOT NULL,
[SchLabel] [varchar](5) NOT NULL,
[SchAction] [int] NOT NULL,
[SchWeekDay] [int] NOT NULL,
[Schtime] [datetime] NOT NULL,
[projectId] [int] NULL ,
[modifiedBy] [int] NULL ,
[modified] [datetime] NULL 
Constraint PK_Schedule PRIMARY KEY(SchNumber,SchLabel,SchAction,SchWeekDay,Schtime)
)
GO

CREATE TABLE dbo.Rules (
[RulNumber] [int] NOT NULL,
[RulResult] [varchar](2) NOT NULL,
[RulCount] [int] NOT NULL,
[RulConsecutive] [bit] NOT NULL,
[RulCallback] [bit] NOT NULL,
[RulInterviewer] [varchar] (10) NULL,
[RulDelay] [int],
[RulUnit] [int],
[RulPriority] [int],
[RulPriorityType] [int],
[RulWaveInc] [bit],
[projectId] [int] NULL ,
[modifiedBy] [int] NULL ,
[modified] [datetime] NULL 
Constraint PK_Rules PRIMARY KEY(RulNumber)			
)
GO					

CREATE TABLE [dbo].[ExtendedRules](
[ExtNumber] [int] NOT NULL,
[ExtNewResult] [varchar](2) NULL,
[ExtLifeState] [varchar](3900) NULL,
[ExtResultsSequence] [varchar](4000) NOT NULL,
[ExtCallback] [bit] NOT NULL,
[ExtInterviewer] [varchar](10) NULL,
[ExtDelay] [int] NULL,
[ExtUnit] [int] NULL,
[ExtPriority] [int] NULL,
[ExtPriorityType] [int] NULL,
[ExtWaveInc] [bit] NULL,
[projectId] [int] NULL,
[modifiedBy] [int] NULL,
[modified] [datetime] NULL,
Constraint PK_ExtendedRules PRIMARY KEY(ExtNumber)						
)
GO

CREATE TABLE dbo.Shift (
[ShiShift] [int] NOT NULL,
[ShiWeekDay] [int] NOT NULL,
[shiStarttime] [datetime] NULL,
[ShiEndTime] [datetime] NULL,
[projectId] [int] NULL ,
[modifiedBy] [int] NULL ,
[modified] [datetime] NULL 
Constraint PK_Shift PRIMARY KEY(ShiShift))
GO

CREATE TABLE dbo.Historic (
[HisRespondent] [varchar] (10) NOT NULL,
[HisCallNumber] [int] NOT NULL,
[HisInterviewer] [nvarchar] (10) NOT NULL,
[HisResult] [varchar] (2) NOT NULL,
[HisCallDate] [datetime] NOT NULL,
[HisTimeSlot] [int] NULL,
[HisCallDuration] [int] NOT NULL,
[HisDataType] [int] NULL,
[HisStartQuestion] [nvarchar] (10) NULL,
[HisEndQuestion] [nvarchar] (10) NULL,
[HisMonitoring] [bit] NULL,
[HisDialerLine] [int] NULL,
[HisWait] [int] NOT NULL,
[HisPause] [int] NOT NULL,
[HisFileReference] [varchar] (120) NULL,
[HisPreviousCallDate] [datetime] NULL,
[HisLifeState] [varchar] (2) NULL,
[projectId] [int] NULL ,
[collectMode] [int] NULL				
Constraint PK_Historic PRIMARY KEY(HisRespondent,HisCallNumber)
)
CREATE INDEX [IxHisRespondent] ON [Historic] ([HisRespondent]) ON [PRIMARY]

ALTER TABLE [dbo].[Historic] ADD 
CONSTRAINT [FK__Historic__HisRes__0EA330E9] FOREIGN KEY 
(
	[HisRespondent]
) REFERENCES [dbo].[Respondent] (
	[ResRespondent]
) ON DELETE CASCADE 
GO

CREATE TABLE dbo.Note (
[NotRespondent] [varchar] (10) NOT NULL,
	[NotDateTime] [datetime] NOT NULL,
	[NotInterv] [nvarchar] (10) NOT NULL,
	[NotQuestion] [nvarchar] (10) NOT NULL,
	[NotMatrix] [int] NULL,
	[NotNote] [nvarchar] (500) NULL,
	[projectId] [int] NULL ,
	[collectMode] [int] NULL ,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
Constraint PK_Note PRIMARY KEY(NotRespondent,NotDateTime,NotInterv)
)
CREATE INDEX [IxNotRespondent] ON [Note] ([NotRespondent]) ON [PRIMARY]

ALTER TABLE [dbo].[Note] ADD 
CONSTRAINT [FK__Note__NotRespond__117F9D94] FOREIGN KEY 
(
	[NotRespondent]
) REFERENCES [dbo].[Respondent] (
	[ResRespondent]
) ON DELETE CASCADE 
GO
				
CREATE TABLE dbo.Response (
[RpsRespondent] [varchar] (10) NOT NULL,
	[RpsQuestion] [nvarchar] (10) NOT NULL,
	[RpsMatrix] [int] default 1,
	[RpsMention] [int] default 1,
	[RpsContent] [nvarchar] (100) NULL,
	[RpsOpened] [ntext] NULL,
	[RpsType] [int] NOT NULL,
	[projectId] [int] NULL ,
	[collectMode] [int] NULL ,
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
Constraint PK_Response PRIMARY KEY(RpsRespondent,RpsQuestion,RpsMatrix,RpsMention,RpsType)
)

CREATE INDEX [IxRpsRespondent] ON [Response] ([RpsRespondent]) ON [PRIMARY]		

CREATE NONCLUSTERED INDEX IX_Response_QuestionMention
ON [dbo].[Response] ([RpsQuestion],[RpsMention],[RpsType])
INCLUDE ([RpsRespondent],[RpsContent])


ALTER TABLE [dbo].[Response] ADD 
CONSTRAINT [FK__Response__RpsRes__145C0A3F] FOREIGN KEY 
(
	[RpsRespondent]
) REFERENCES [dbo].[Respondent] (
	[ResRespondent]
) ON DELETE CASCADE 
GO

CREATE TABLE [dbo].[RespondentState] (
	[projectId] [int] NOT NULL ,
	[RespondentId] [varchar] (10) NOT NULL ,
	[isBlocked] [bit] NOT NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[RespondentState] WITH NOCHECK ADD 
	CONSTRAINT [PK_Table1] PRIMARY KEY  CLUSTERED 
	(
		[projectId],
		[RespondentId]
	)  ON [PRIMARY] 


ALTER TABLE [dbo].[RespondentState] ADD 
	CONSTRAINT [FK_RespondentState_Respondent] FOREIGN KEY 
	(
		[RespondentId]
	) REFERENCES [dbo].[Respondent] (
		[ResRespondent]
	) ON DELETE CASCADE 
GO

CREATE TABLE dbo.TimeSlotHit (
[TshRespondent] [varchar] (10) NOT NULL,
	[TshTimeSlot] [int] NOT NULL
Constraint PK_TimeSlotHit PRIMARY KEY(TshRespondent,TshTimeSlot)
)

CREATE INDEX [IxTshRespondent] ON [TimeSlotHit] ([TshRespondent]) ON [PRIMARY]

CREATE INDEX [IxTshTimeSlot] ON [TimeSlotHit] ([TshTimeSlot]) ON [PRIMARY]			

ALTER TABLE [dbo].[TimeSlotHit] ADD 
CONSTRAINT [FK__TimeSlotH__TshRe__1920BF5C] FOREIGN KEY 
(
	[TshRespondent]
) REFERENCES [dbo].[Respondent] (
	[ResRespondent]
) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

CREATE TABLE [dbo].[QuotasAgent] (
[Stratum] [int] NOT NULL ,
[AgentId] [int] NOT NULL ,
[Quota] [int] NULL ,
[Done] [int] NULL ,
[Sent] [int] NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[QuotasAgent] WITH NOCHECK ADD 
CONSTRAINT [PK_QuotasAgent] PRIMARY KEY  CLUSTERED 
(
	[Stratum],
	[AgentId]
)  ON [PRIMARY] 
GO
			
CREATE TABLE [dbo].[CapiAgent] (
[AgentId] [int] NOT NULL ,
[Status] [int] NULL ,
[ModeCreate] [char](1) NULL ,
[ToSend] [int] NULL ,
[LastAccess] [smalldatetime] NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[CapiAgent] WITH NOCHECK ADD 
CONSTRAINT [PK_CapiAgent] PRIMARY KEY  CLUSTERED 
(
	[AgentId]
)  ON [PRIMARY] 
GO			

CREATE TABLE [dbo].[CAPIRespondentByAgent] (
[AgentID] [int] NOT NULL ,			
[ResRespondent] [varchar] (50) not null
) ON [PRIMARY]

ALTER TABLE [dbo].[CAPIRespondentByAgent] WITH NOCHECK ADD 
CONSTRAINT [PK_CAPIRespondentByAgent] PRIMARY KEY  CLUSTERED 
(
	[AgentID],
	[ResRespondent]
)  ON [PRIMARY] 
GO

CREATE TABLE [dbo].[CAPIRespondentsLocalisation](
	[ResRespondent] [nvarchar](20) NOT NULL,
	[MachineName] [nvarchar](50) NULL,
	[TransfertDateTime] [datetime] NULL,
	[NextAction] [int] NULL,
	[Status] [int] NULL,
[NextActionAgentID] [int] NULL,
CONSTRAINT [PK_CAPIRespondentsLocalisation] PRIMARY KEY CLUSTERED 
(
	[ResRespondent] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
			
CREATE TABLE [dbo].[CAPIRespondentsLocalisationHistory](
	[ResRespondent] [nvarchar](20) NOT NULL,
[ID] [int] NOT NULL,
[HistoryDateTime] [datetime] NOT NULL,
[Text] [nvarchar](500)NOT NULL,
[CreatedBy] [int] NOT NULL,
[SyncroProcessLog] [nchar](1) NULL,
CONSTRAINT [PK_CAPIRespondentsLocalisationHistory] PRIMARY KEY CLUSTERED 
(
[ResRespondent] ASC,
[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[CAPIResultCodeActions](
	[INTCode] [nvarchar](20) NOT NULL,
	[ActionID] [int] NOT NULL,
CONSTRAINT [PK_CAPIResultCodeActions] PRIMARY KEY CLUSTERED 
(
	[INTCode] ASC,
	[ActionID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[Stratum] (
[StrRespondent] [varchar] (10)  NOT NULL ,
[StrStratum] [int] NOT NULL 
) ON [PRIMARY]

ALTER TABLE [dbo].[Stratum] WITH NOCHECK ADD 
	CONSTRAINT [PK_Stratum] PRIMARY KEY  CLUSTERED 
	(
		[StrStratum],
		[StrRespondent]
	)  ON [PRIMARY] 

ALTER TABLE [dbo].[Stratum] ADD 
	CONSTRAINT [FK__Stratum__StrResp__239E4DCF] FOREIGN KEY 
	(
		[StrRespondent]
	) REFERENCES [dbo].[Respondent] (
		[ResRespondent]
	) ON DELETE CASCADE  ON UPDATE CASCADE ,
	
	CONSTRAINT [FK__Stratum__StrStra__24927208] FOREIGN KEY 
	(
		[StrStratum]
	) REFERENCES [dbo].[Quota] (
		[QtStratum]
	) ON DELETE CASCADE  ON UPDATE CASCADE 
GO

CREATE TABLE dbo.Installation (
[INSSECTION] [varchar] (50) NOT NULL ,
	[INSIDENT] [varchar] (50) NOT NULL ,
	[INSVALUE] [varchar] (250) NULL,
	[projectId] [int] NULL ,				
	[modifiedBy] [int] NULL ,
	[modified] [datetime] NULL 
)

ALTER TABLE [Installation] WITH NOCHECK ADD
Constraint PK_Installation PRIMARY KEY CLUSTERED
(
	[INSSECTION],
		[INSIDENT]
	) ON [PRIMARY]					
GO

--insert into INSTALLATION values('OPTIONS','ALLOW REVIEW','1',#PROJECTID#,0,GETUTCDATE())			
--insert into INSTALLATION values('OPTIONS','ALLOWED BACKWARDS JUMPS','1',#PROJECTID#,0,GETUTCDATE())			
--insert into INSTALLATION values('OPTIONS','CONFIRM ENTRY','0',#PROJECTID#,0,GETUTCDATE())			
--insert into INSTALLATION values('OPTIONS','DISPLAY ALIAS','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('OPTIONS','REVIEW OPEN ENDS','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('OPTIONS','PERMANENT MESSAGE','$Q $N',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('OPTIONS','ALLOW LOWER CASE IN OPENEND','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('RULES','MAX WAVES','0',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('RULES','PRIORITY OF FRESH','0',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('CALENDAR','DAY1','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('CALENDAR','DAY2','1',#PROJECTID#,0,GETUTCDATE())								
--insert into INSTALLATION values('CALENDAR','DAY3','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('CALENDAR','DAY4','1',#PROJECTID#,0,GETUTCDATE())								
--insert into INSTALLATION values('CALENDAR','DAY5','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('CALENDAR','DAY6','1',#PROJECTID#,0,GETUTCDATE())							
--insert into INSTALLATION values('CALENDAR','DAY7','1',#PROJECTID#,0,GETUTCDATE())							
--GO				

CREATE TABLE dbo.Interviewer (
[IntNumber] [int] NOT NULL,
	[IntInitiale] [nvarchar] (4),
	[IntName] [nvarchar] (30),
	[SessionCompleted] [int],
	[SessionInProgress] [int],
	[SessionToComplete] [int],
	[QuestionMonitored] [int],
	[QuestionToMonitor] [int]
Constraint PK_Interviewer PRIMARY KEY(IntNumber)
)				
CREATE INDEX [IxIntervIni] ON  [Interviewer] ([IntInitiale]) ON [PRIMARY]			
GO				

CREATE TABLE dbo.ImportedFields (
[IFNumber] [int] NOT NULL,
	[IFQuestion] [nvarchar] (10),
	[IFRecord] [int],
[IFPosition] [int],
[IFWidth] [int],
[IFType] [int],
[IFSkipPst] [bit],
[IFSkipAbst] [bit],
[IFFieldIsQuest] [bit],
[IFFieldName] [varchar] (50) NULL,
[projectId] [int] NULL ,				
[modifiedBy] [int] NULL ,
[modified] [datetime] NULL 
Constraint PK_ImportedFields PRIMARY KEY(IFNumber)
)			
GO

CREATE TABLE dbo.ImportHistory (
[IHNumber] [int] NOT NULL,
[IHDateTime] [DateTime],
[IHFileName] [VarChar](255),
[IHStartQuest] [nVarChar](10),
[IHEndQuest] [nVarChar](10),
[IHStartNumber] [int],
[IHEndNumber] [int],
[projectId] [int] NULL ,				
[modifiedBy] [int] NULL				
Constraint PK_ImportHistory PRIMARY KEY(IHNumber)
)			
GO


CREATE PROCEDURE dbo.sp_GetSampleInformation  AS
--Sample Distribution
select * from
(
select '##Global_FreshSample##' as label ,(select count(*) from Respondent where ResCall=0) as value,1 as valueorder
union
select '##Global_PassedCallBacks##',(select count(*) from Respondent where ResCallbackDate is not null and  ResCallbackDate >0 and ResCallbackDate < GETUTCDATE() and ResCompleted=0),2 as valueorder
union
select '##Global_Unavailables##', (select count(*) from Respondent where ((ResCallbackDate is null or ResCallbackDate <=0) and ResCall>0 and ResCompleted=0)),3 as valueorder
union
select '##Global_CallBacksToCome##', (select count(*) from Respondent where ResCallbackDate is not null and  ResCallbackDate >= GETUTCDATE() and ResCompleted=0) ,4 as valueorder
union
select '##Global_Completed##', (select count(*) from Respondent where ResCompleted=1) ,5 as valueorder

)
sampleinfo
order by valueorder


--Sample availability for call
select * from
(
select
'##Global_FreshSample##' as label ,(select count(*) from Respondent where ResCall=0 and ResBlocked=0) as value,1 as valueorder
union
select '##Global_PassedCallBacks##',(select count(*) from Respondent where ResCallbackDate is not null and  ResCallbackDate >0 and ResCallbackDate < GETUTCDATE() and ResCompleted=0 and ResBlocked=0),2 as valueorder
union
select '##Global_Unavailables##',count(*) as value, 3 as valueorder from Respondent where 
(ResCall=0 and ResBlocked=1) or 
(ResCallbackDate is not null and  ResCallbackDate >0 and ResCallbackDate < GETUTCDATE() and ResCompleted=0 and ResBlocked=1) or 
(ResCallbackDate is not null and  ResCallbackDate >= GETUTCDATE() and ResCompleted=0) or 
(ResCompleted=1) or
((ResCallbackDate is null or ResCallbackDate <=0) and ResCall>0 and ResCompleted=0)
)
sampleinfo
order by valueorder		
GO				

CREATE PROCEDURE dbo.sp_FindRespondentGroupAccordingToQuotas @ProjectId int, @Respondent varchar(10) ,@Group int OUTPUT  AS
Set @Group=0
Select @Group= QtGroup 
From   Quota  Where QtGroup >0
and Exists(Select StrStratum from Stratum where 
			StrStratum = QtStratum and StrRespondent=@Respondent
		)
RETURN(@Group)
GO

CREATE PROCEDURE dbo.sp_RespondentIsInClosedStrate  @ProjectId int, @Respondent varchar(10)   AS

Select  count(QtStratum)
From  Quota 
Where QtStatus =2
and Exists ( select StrStratum from Stratum 
			where (StrStratum =QtStratum  and StrRespondent=@Respondent))
GO

CREATE PROCEDURE dbo.sp_RespondentinIsInHalfOpenstrata   @ProjectId int,@Respondent varchar(10)   AS
Select  count(*)
From Stratum S,Quota Q
Where Q.QtStatus =1
and S.StrStratum=Q.QtStratum
and S.StrRespondent=@Respondent			
GO

CREATE PROCEDURE dbo.sp_UpdateStrataState @projectId int,@userId int AS
Declare @UseQuotas bit
Set @UseQuotas = (Select top 1 INSVALUE From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')


-- strata manually set to closed or with frequency >= quota
update quota set QtStatus = 2, QtStatusTemp = 2 where (QtStatus = 2) or (@UseQuotas=1 and (QtQuota > 0) and (QtFrequence >= QtQuota))

-- strata manually set to half-open and with frequency + online >= quota
update quota set QtStatusTemp = 2 where (QtStatus = 1) and (QtQuota > 0) and (QtFrequence + QtOnLine >= QtQuota)

-- strata manually set to open and with frequency < quota
-- strata manually set to half-open and with frequency + online < quota
update quota set QtStatusTemp = 0 where
	((QtStatus = 0) and ((QtQuota = 0) or (QtFrequence < QtQuota))) or
	((QtStatus = 1) and ((QtQuota = 0) or (QtFrequence + QtOnLine < QtQuota)))
GO
				
--CREATE PROCEDURE dbo.sp_QuotasReindex @ProjectId int ,@userId int AS (moved to 1001)

CREATE PROCEDURE dbo.sp_RespondentIncDecQuota @ProjectId int,@userId int, @Respondent varchar(10) ,@operation bit AS
Declare @CNT int
if @operation=1
set @CNT=1
else
set @CNT=-1

Begin Transaction T1
Update Q with(tablockx) Set Q.QtFrequence = Q.QtFrequence+@CNT
From Stratum S with(nolock), Quota Q 
Where (S.StrStratum = Q.QtStratum and S.StrRespondent=@Respondent) 

Update Q with(tablockx) Set Q.QtFrequence = Q.QtFrequence+@CNT
From Quota Q 
Where QtStratum=0

Commit Transaction T1

Update Quota Set QtFrequence = 0
Where QtFrequence<=0

if @CNT=1
begin
	Declare @UseQuotas bit
	Set @UseQuotas = (Select top 1 INSVALUE From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')
	if @UseQuotas is NULL Set @UseQuotas = 0

	if @UseQuotas = 1
	begin
		Declare @NonClosedStrata int
		Select @NonClosedStrata = Count(QtStratum) from Quota where QtStratum>0 and QtQuota>0 and QtFrequence>=QtQuota and QtStatus<>2 -- find if there are strata (excluding the global strata, 0) that should be closed

		if @NonClosedStrata > 0
		begin		        
			exec sp_UpdateStrataState @projectId,@userId
			exec sp_QuotasReindex @projectId,@userId
		end
	end
end
GO
				
CREATE PROCEDURE dbo.sp_RespondentIncDecUnused @ProjectId int,@userId int,@Respondent varchar(10) ,@operation bit AS
Declare @CNT int
if @operation=1 
set @CNT=1
else
set @CNT=-1
 
Begin Transaction T1 

Update Q with(tablockx)
Set Q.QtUnused = Q.QtUnused+@CNT
From Stratum S with(nolock), Quota Q 
Where (S.StrStratum = Q.QtStratum
and S.StrRespondent=@Respondent)

Update Q with(tablockx)
Set Q.QtUnused = Q.QtUnused+@CNT
From Quota Q 
Where QtStratum=0

Commit Transaction T1

Update Quota
Set QtUnused = 0
Where QtUnused<=0
GO

CREATE PROCEDURE dbo.sp_RespondentConnectQuotas @ProjectId int,@Respondent varchar(10), @Action int   AS

Begin Transaction T1 

IF (@Action=1)
BEGIN
	Update Q with(tablockx) 
	Set Q.QtOnLine = Q.QtOnLine+1
	From Stratum S with(nolock), Quota Q 
			Where (S.StrStratum = Q.QtStratum) and (S.StrRespondent=@Respondent)
END
ELSE IF (@Action=2)  
BEGIN
	Update Q with(tablockx)
	Set Q.QtOnLine = Q.QtOnLine-1
	From Stratum S with(nolock), Quota Q
			Where (S.StrStratum = Q.QtStratum) and (Q.QtOnLine > 0) and (S.StrRespondent=@Respondent)
END
ELSE IF (@Action=3) 
BEGIN
	Update Q with(tablockx)
	Set Q.QtOnLine = 0
	From Quota Q
END
   
Commit Transaction T1
GO
				
CREATE PROCEDURE dbo.sp_SetRespondentInTimeSlot   @ProjectId int,@Respondent varchar(10) ,@TSLOT int,@AddDel bit  AS
if (@AddDel=0)  
DELETE FROM TimeSlotHit Where TshRespondent=@Respondent 
					and TshTimeSlot = @TSLOT
else
if ( not Exists (Select * From TimeSlotHit Where TshRespondent=@Respondent  and TshTimeSlot = @TSLOT )
	and Exists (Select * From TIMESLOT Where TslTimeSlot=@TSLOT)
)
INSERT INTO TimeSlotHit VALUES(@Respondent,@TSLOT)
GO

CREATE PROCEDURE dbo.sp_RecomputeTimeZones
@projectId int,
         @userId int
 AS
update Respondent set ResTimeZone=timezone,projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE()
 from
areacodetz
where 
code=SUBSTRING(Resphone,1,3)

Update Response 
Set RpsContent=ResTimeZone ,projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE()
from Respondent
where
ResRespondent=RpsRespondent and RpsQuestion='TZONE' and RpsMatrix=1 and RpsMention=1 and RpsType=0
GO

CREATE PROCEDURE dbo.sp_UpdateForNew  @projectId int , @userId int,@Number as varchar(10),@Group as int  AS

Declare @Quest varchar(10)

Update Respondent  Set ResCall=1, ResPreviousCallDate=ResCallbackDate,ResCallbackDate=0,projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE() Where ResRespondent=@Number
Select @Quest=ResRespondent from Respondent  where ResRespondent=@Number
Update dbo.BufferNew Set ResCall=1 Where Respondent= @Number and intgroup=@Group
GO

CREATE PROCEDURE dbo.sp_New_Fresh @ProjectId int, @GroupNbr int, @nbBROWSE int, @Strata int AS

Declare @StrGroup  VarChar(3)
if @GroupNbr<10
	Set @StrGroup='G0'+Convert(Char(1),@GroupNbr)
 else
	Set @StrGroup='G'+Convert(Char(2),@GroupNbr)
set ROWCOUNT  @NbBrowse

Insert Into #TempNew (RespondentID,intgroup, Priority,Phone)
Select ResRespondent,@GroupNbr,ResPriority,Resphone  from Respondent  Where 
(
	(ResIntervCall=@StrGroup)
	or    
	(
	@StrGroup='G00' 
	and
	(
		(ResIntervCall='***')
		or
		(RTrim(ResIntervCall)='')
	)
	)
)
and
(ResCall=0)
and
( (@Strata = 0) or
	(exists
	(SELECT StrRespondent FROM Stratum with(nolock)
	WHERE (StrStratum = @Strata) and (StrRespondent=ResRespondent)
	)
	)
) 
and
(not exists
(SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock)
	Where QtStratum=StrStratum AND QtStatusTemp=2 AND StrRespondent=ResRespondent
)
)
and 
(not exists
(select Respondent from dbo.BufferNew where  Respondent=ResRespondent and intgroup=@GroupNbr)
)
 and 
 (not exists
  (select RespondentID from #TempNew where  RespondentID=ResRespondent and intgroup=@GroupNbr)
 )
 and
 (not exists
  (SELECT Phone FROM DoNotCallList with(nolock) WHERE Resphone=Phone))
  
 order by ResSeed

set ROWCOUNT  0		
GO

CREATE PROCEDURE dbo.sp_New  @ProjectId int, @GroupNbr int , @BrowseNbr int,@LocalTimeZone int AS
-- version 23 octobre 2006
Declare @StrGroup  VarChar(10)
if @GroupNbr< 10
	Set @StrGroup='G0'+Convert(Char(1),@GroupNbr)
else
	Set @StrGroup='G'+ Convert(Char(2),@GroupNbr)


delete From dbo.BufferNew where intgroup = @GroupNbr

declare @CurrentDate DateTime

declare @gmt int
select @gmt = gmtbias + dstbias*dstactive from dbo.TimeZones where id=@LocalTimeZone

set @CurrentDate = DateAdd(hh ,-@gmt,GetUTCDate())
declare @TS int

create table #tzts  (
   timezone int,
   timeslot int
)

insert into #tzts
select id+0 as timezone,dbo.TimeSlotNumber(DateAdd(hh,gmtbias + dstbias*dstactive,@CurrentDate)) as timeslot
from dbo.TimeZones

insert into #tzts  (timezone,timeslot) values(0,dbo.TimeSlotNumber(GetUTCDate()))

declare @D1 datetime
declare @RC bit
declare @REP VarChar(10)
declare @priority int
declare @cmpcb datetime
declare @theseed float
declare @phone varchar(20)
declare @Smooth bit
declare @UseQuotas bit
declare @Replicate bit
declare @NBW int -- number of weights
declare @FreshPriority int 
declare @NBH int -- number of half-open strata
declare @totalusable int
declare @NBF int

declare @MaxUsable table (
   Stratum int,
   Usable int,
   Selected int,
   Unused int,
   Weight float default 0,
   CalcWeight float default 0,
   ToUse int Default 0
)

Set @FreshPriority = (Select top 1 INSVALUE From Installation where INSSECTION='RULES' and INSIDENT='PRIORITY OF FRESH')
if (@FreshPriority IS NULL) SET @FreshPriority = 0


Set @Smooth= (Select top 1 INSVALUE From Installation where INSSECTION='QUOTAS'    and INSIDENT='QUOTASSMOOTH')
if(@Smooth IS NULL) SET @Smooth=0

Select @NBW = Count(QtStratum) from Quota with(nolock) where QtWeight >0 and QtStatusTemp<>2 AND QtUnused > 0 
			and (QtGroup=@GroupNbr or QtGroup=0)
            
Select @NBH = Count(QtStratum) from Quota with(nolock) where QtStatus = 1 
			and ( QtGroup=@GroupNbr or QtGroup=0)

Set @UseQuotas = (Select top 1 INSVALUE From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')
if  @UseQuotas is NULL Set @UseQuotas = 0

Set @Replicate = (Select top 1 coalesce(INSVALUE,0) From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTAMODEREPLICATE')
if  @Replicate is NULL Set @Replicate = 0
if  @Replicate = 1 Set @NBW = 0 -- weights and replicates are not compatible : ignore the weights

if @NBW > 0 
  Create Table  #TempNew (
	RespondentId varchar (10),
	intgroup int default 0,
	Priority int default 0,
	RandomSeed int default 0,
	Phone varchar (20)
  )

set @totalUsable = @BrowseNbr
if @Usequotas = 1 
begin
   if @NBW > 0 or @NBH > 0 
   begin
	  insert into @MaxUsable
		 select QtStratum,
			case QtStatus
				 when 2 then 0
				 when 1 then 
				 case 
					  when QtQuota > QtFrequence + QtOnLine then
						   QtQuota- (QtFrequence+QtOnLine)
					  else 
						0
				 end     
				 else @browsenbr
			end, 
			0, 
			QtUnused,
			QtWeight,
			0,
			0
		 from quota
		 where (QtGroup=@GroupNbr or QtGroup=0) and QtQuota > 0 and QtStatus < 2
	  set @totalusable = (select MIN(usable) from @maxusable where stratum >0 and Usable > 0) 
	  if @totalusable is NULL set @totalusable = 0
      
	  if @NBW > 0 and @Smooth = 0 -- complete the table for strata without quotas
	  begin
		insert into @MaxUsable
		   select QtStratum,
			  case QtStatus
			  when 2 then 0
			  else @BrowseNbr
			  end, 
			  0,
			  QtUnused,
			  QtWeight,
						  0,
						  0
		   from Quota
		   where (QtGroup=@GroupNbr or QtGroup=0) and QtQuota <= 0 and QtWeight >0 and QtStatus < 2
	  end
   end   
end   
else
begin
   if @NBW > 0 
   begin
	  insert into @MaxUsable
		 select QtStratum,
			case QtStatus
			when 2 then 0
			else @BrowseNbr
			end, 
			0,
			QtUnused,
			QtWeight,
			0,
			0
		 from Quota
		 where (QtGroup=@GroupNbr or QtGroup=0) and (QtWeight >0) and QtStatus < 2
   end   
end

if @replicate = 0 
begin
   if @NBW = 0 
   begin -- general : no weights - no replicates
   --We must put this statement in the execute command since we can't use a dynamic top statement.	
   exec('	
   INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
   SELECT TOP ' + @totalUsable + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' FROM Respondent r 
   WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
		 and
		 ((ResCall=0) OR ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate())))
		 and
		 ((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
		 and
		 (ResBlocked=0)
		 and
		 (NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
		 and
		 (NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
		 order by ResPriority desc, ResCallbackDate, ResSeed
   ')
   end
   else
   begin   -- 1: call-backs with high priority - weights present
	   exec('	
		INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
		SELECT TOP ' + @totalUsable + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' FROM Respondent r 
		WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
				and         
				((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and
				((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
				and
				(ResBlocked=0)
				and
				(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
				and
				(NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
				and
				(ResPriority>= ' + @FreshPriority + ')
				order by ResPriority desc, ResCallbackDate, ResSeed
		')
	   select @NBF = count (*) from dbo.BufferNew where intgroup=@GroupNbr
	   if @NBF = 0 
	   begin  -- 2: fresh weighted cases 
			  -- fill the maximum number of Respondents that can be selected for each strata

		   Declare @S int, @P float ,@Q float ,@E float , @SP float
		   Set @SP = 0

		   Declare QCF Cursor for
		   Select QtStratum,QtWeight,QtQuota, QtFrequence from Quota with(nolock) 
				  where QtWeight > 0 and QtStatusTemp<>2 and QtUnused > 0 and (QtGroup=@GroupNbr or QtGroup = 0)
		   open QCF
		   fetch next From QCF into @S,@P,@Q,@E
		   WHILE @@FETCH_STATUS = 0
		   begin
			  if @Smooth <> 0 -- weights are evaluated according to the copmpleted and online frequencies
			  begin
				 if @Q = 0 or @Q-@E <= 0
				 begin
				   Set @P = 0
				   Update @MaxUsable  set CalcWeight=0 Where Stratum=@S
				 end
				 else
				 begin
				   Set @P = @Q-@E
				 end
			  end
			  if @P > 0 -- computing the sum of the weights
			  begin
				 Set @SP = @SP + @P
				 Update @MaxUsable set CalcWeight=@SP Where Stratum=@S
			  end
			  fetch next From QCF into @S,@P,@Q,@E
		   end -- while
		   close QCF
		   deallocate QCF

		   Update @MaxUsable set CalcWeight = 0 where Weight <= 0

		   Declare @I int, @ST int, @RespID varchar(10)
		   Set @I = 1
		   While @I <= @BrowseNbr -- randomly select the number of Respondents for each weighted strata
		   begin
			   Set @ST =(Select top 1 Stratum From @MaxUsable  
				   where  Weight > 0 and CalcWeight >= (rand() * @SP) order by CalcWeight ASC)
			   Update  @MaxUsable set ToUse = ToUse + 1 where stratum = @ST and Usable > 0
			   Update  @MaxUsable set Usable = Usable -1 where stratum = @ST and Usable > 0
			   Set @I = @I+1
		   end -- while

		   select @RC = count(Respondent) from dbo.bufferNEW where intgroup=@GroupNbr and ResCall = 0

		   /* insert weighted Respondents in the BufferNew table */
		   Declare @ToUse int
			  if rand() > .5 -- to avoid always presenting the same strata first
				 Declare CurLocal Cursor For
						 Select stratum, ToUse From  @MaxUsable where ToUse >= 1 order by Stratum ASC
			  else
				 Declare CurLocal Cursor For
						 Select stratum, ToUse From  @MaxUsable where ToUse >= 1 order by Stratum DESC
		   OPEN  CurLocal
		   Fetch next From CurLocal into @ST, @ToUse
		   While @@FETCH_STATUS=0
		   begin
			  EXEC sp_New_Fresh @projectId,@GroupNbr, @ToUse, @ST
			  Fetch next From CurLocal into @ST, @ToUse
		   end -- while
		   CLOSE CurLocal
		   Deallocate CurLocal        

		   select @ST= count(RespondentID) from #TempNew where intgroup=@GroupNbr
		   /* if no weighted Respondents were extracted, then complete the buffer with other Respondents  */
		   if @ST-@RC = 0 
		   begin
			  EXEC sp_New_Fresh @projectId,@GroupNbr, @TotalUsable, 0
		   end
			--------------------------- on brasse les nouvelles avec poids
			update #TempNew set RandomSeed = (RespondentId * 3331) % 99

			insert into dbo.BufferNew (Respondent, intgroup, priority, seed, Phone)
				select  RespondentId, IntGroup, Priority, RandomSeed, Phone
					from #TempNew 
					order by RandomSeed  ASC
		end
		select @NBF = count (*) from dbo.BufferNew where intgroup = @GroupNbr
		if @NBF = 0 
		begin -- 3: call-backs with low priority - weights present
		   exec('	
		   INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
		   SELECT TOP ' + @totalUsable + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' 
				  FROM Respondent r 
		   WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
				and         
				((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and
				((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
				and
				(ResBlocked=0)
				and
				(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
				and
				(NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
				and
				(ResPriority < '+ @FreshPriority + ')
				order by ResPriority desc, ResCallbackDate, ResSeed
				')
		          
		end
   end
end
else
begin
  -- replicates
		-- 1: call-backs with high priority - regardless of statustemp
		exec('	
		INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
		SELECT TOP ' + @BrowseNbr + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' FROM Respondent r 
		WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
				and         
				((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and
				((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
				and
				(ResBlocked=0)
				and
				(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatus=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
				and
				(NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
				and
				(ResPriority >= '+ @FreshPriority + ')
				order by ResPriority desc, ResCallbackDate, ResSeed
		')
		select @NBF = count (*) from dbo.BufferNew where intgroup=@GroupNbr
		set @NBF = @BrowseNbr - @NBF
		if @NBF > 0 
		begin
		-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
		   exec('	
		   INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
		   SELECT TOP' + @TotalUsable + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' FROM Respondent r 
		   WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
				and         
				(ResCall=0)
				and
				((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
				and
				(ResBlocked=0)
				and
				(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
				and
				(NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
				and
				(ResPriority>=' + @freshPriority +')
				order by ResSeed
		   ')
		end
		select @NBF = count (*) from dbo.BufferNew where intgroup=@GroupNbr
		set @NBF = @BrowseNbr - @NBF
		if @NBF > 0 
		begin
		-- 3 : call-backs with low priority - regardless of statusTemp
		   exec('	
		INSERT INTO dbo.BufferNew (Respondent,intgroup,Priority,Callbackdate,seed,phone,projectId)
		SELECT TOP ' + @Nbf + ' ResRespondent,' + @GroupNbr + ',ResPriority,ResCallbackDate,ResSeed,Resphone,'+@projectId + ' FROM Respondent r 
		WHERE ((ResIntervCall=''' + @StrGroup + ''') or ((''' + @StrGroup + '''=''G00'') and ((ResIntervCall=''***'') or(RTrim(ResIntervCall)=''''))))
				and         
				((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and
				((ResTimeSlot=0) OR ((ResRespondent not in(SELECT  TshRespondent  FROM TimeSlotHit Where TshTimeSlot=(SELECT top 1 timeslot FROM #tzts where ResTimeZone=timezone)))))
				and
				(ResBlocked=0)
				and
				(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatus=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
				and
				(NOT EXISTS (SELECT phone FROM doNotCallList with(nolock)WHERE Resphone=phone))
				and
				(ResPriority < ' + @freshPriority + ')
				order by ResPriority desc, ResCallbackDate, ResSeed
		   ')
		end
	end

drop table #tzts
if @NBW > 0 drop table #TempNew
GO


CREATE PROCEDURE  dbo.sp_DeleteRespondent  @Quest VarChar(10)  AS

if  @quest<>''
begin
Delete From Note         where NotRespondent =@Quest
Delete From Historic     where HisRespondent =@Quest
Delete From Stratum      where StrRespondent =@Quest
Delete From TimeSlotHit  where TshRespondent =@Quest
Delete From Response     where RpsRespondent =@Quest

Delete From Respondent   where ResRespondent =@Quest				
end
GO

CREATE PROCEDURE dbo.sp_ResetBufferNew AS
	truncate table BufferNew			
GO

CREATE PROCEDURE  dbo.sp_ResetProjectData   AS
Exec sp_ResetBufferNew				

truncate table  Note        
truncate table  Historic    
truncate table  Stratum     
truncate table  TimeSlotHit 
truncate table  Response    
truncate table  ImportHistory		
truncate table Respondentpin
truncate table Respondentstate
delete Respondent  

update Quota set QtOnLine=0,QtUnused=0,QtFrequence=0	
update QuotasAgent set Done=0, Sent=0
GO


CREATE PROCEDURE [dbo].[sp_ValidateSampleWithDNC]  @projectId int , @userId int AS
set NOCOUNT on
declare @DNCResult VarChar(5);								
select @DNCResult = rtrim([value]) from systemConfig where [name]='DoNotCallListResultCode'

declare @RetiredRespondent table (
	ResRespondent VarChar(10)
)

insert into @RetiredRespondent
select ResRespondent from Respondent 
join donotcalllist on 
Resphone = Phone
where ResCompleted=0 and ResCodeResult <> @DNCResult

insert into historic 
(HisRespondent,HisCallNumber,HisInterviewer,
HisResult,HisCallDate,HisTimeSlot,HisCallDuration,HisDataType,
HisStartQuestion,HisEndQuestion,HisMonitoring,HisDialerLine,HisWait,HisPause,HisFileReference,HisPreviousCallDate,projectId,collectmode)
select ResRespondent,COALESCE((Select max(HisCallNumber)+1 from historic where hisRespondent=ResRespondent),1),@userId,@DNCResult,GETUTCDATE(),0,0,0,'','',0,0,0,0,'',(Select max(HisCallDate)from historic where hisRespondent=ResRespondent),
@projectId,0
from @RetiredRespondent

update Respondent set ResCallbackDate=0,ResCall=1,ResCallCount=ResCallCount+1,ResCodeResult=@DNCResult,projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE()
from  Respondent a join @RetiredRespondent b on a.ResRespondent=b.ResRespondent

select count(ResRespondent) as RetiredRespondentCount from @RetiredRespondent		
GO

CREATE  PROCEDURE dbo.sp_GenerateRandomPIN
(
@mask varchar(20),
@pin varchar(20) output
)
as

declare @maskLen int
set @maskLen = LEN(@mask)

declare @i int
set @i = 1

declare @currentChar char

declare @result varchar(20)
set @result = ''

while @i <= @maskLen and @i <= 20
begin
	set @currentChar = substring(@mask,@i,1)

	if @currentChar = 'A'
	begin
		set @result = @result + char(65 + round(25 *  rand(),0))

	end	
	else
	if @currentChar = '9'
	begin
		set @result = @result + char(48 + round(9 *  rand(),0))
	end
	else
	if @currentChar = 'Z'
	begin
		if round(2 *  rand(),0) = 1
			set @result = @result + char(65 + round(25 *  rand(),0))
		else
			set @result = @result + char(48 + round(9 *  rand(),0))
	end
	else
	if @currentChar = '$'
	begin
	set @i = @i+1;
	set @result = @result + substring(@mask,@i,1)
	end
	else
	set @result = @result + @currentChar

	set @i = @i+1
end

set @pin=@result
GO

CREATE PROCEDURE dbo.sp_ImportRandomPIN
			(
	@ProjectId int,
	@userId int,
	@ResRespondent varchar(10),
	@mask varchar(20),
	@pinQuestion varchar(5)
)
AS

declare @loopCount int
set @loopCount=0

declare @pin varchar(20)
set @pin = ''


while 1=1
begin		
	exec sp_GenerateRandomPIN @mask,@pin output

	declare @pinExists int
	select @pinExists = count(rspPin) from RespondentPin where RspPin=@pin

	if @pinExists = 0
	begin
		update RespondentPin set rspPin=@pin where rspRespondent=@ResRespondent

		if @@ROWCOUNT=0
			insert into RespondentPin (RspRespondent,RspPIN,projectId,modifiedBy,modified) values(@ResRespondent,@pin,@ProjectId,@userId,GETUTCDATE())

		break;
	end
	set @loopCount = @loopCount+1

	if @loopCount = 100
	begin
		declare @errormsg varchar(256)
		set @errormsg = 'VOXCOERROR_1001 Unable to generate PIN with mask ' + @mask
		RAISERROR (@errormsg, 16, 1)
		return
	end
end

if @pinQuestion is not null and @pinQuestion <> '' 
begin
	if @pinQuestion='$N'
	begin
		update Respondent set Resphone=@pin where ResRespondent=@ResRespondent
	end
	else
	begin
	update Response set RpsContent=@pin where RpsQuestion=@pinQuestion and RpsMention=1 and RpsMatrix=1 and RpsType=0 and RpsRespondent=@ResRespondent
	if @@ROWCOUNT=0
		insert into Response (RpsRespondent,RpsQuestion,RpsMatrix,RpsMention,RpsContent,RpsOpened,RpsType) values(@ResRespondent,@pinQuestion,1,1,@pin,null,0)
	end
end
GO

CREATE PROCEDURE dbo.sp_RecomputeQuotaCounters @projectId  int  ,@UserId int AS

declare @replicate bit select @replicate=InsValue from installation where insident = 'QUOTASMODEREPLICATE' 
if @replicate=1 
begin 
update quota set QtUnused=unused, qtfrequence=completed, QtOnLine=online from quota 
inner join ( select stratum, sum(unused) as unused, sum(completed) as completed, sum(online) as online from 
( select QtStratum as stratum, case when ResCall=0 then 1 else 0 end as unused, case when ResCompleted=1 then 1 else 0 end as completed, case when ResCallbackDate>0 then 1 else 0 end as online from quota 
left outer join stratum on QtStratum=strstratum left outer join Respondent r on strRespondent=ResRespondent where QtStratum > 0 ) a group by stratum ) b on stratum=QtStratum end else begin update quota set QtUnused=unused, qtfrequence=completed, QtOnLine=0 from quota inner join ( select stratum, sum(unused) as unused, sum(completed) as completed, 0 as online from ( select QtStratum as stratum, case when ResCall=0 then 1 else 0 end as unused, case when ResCompleted=1 then 1 else 0 end as completed from quota left outer join stratum on QtStratum=strstratum left outer join Respondent r on strRespondent=ResRespondent where QtStratum > 0 ) a group by stratum ) b on stratum=QtStratum  end update Respondent set ResIntervCall=newintervcall from Respondent inner join ( select Respondent, case when QtGroup=0 then '' when QtGroup < 10 then 'G0' + cast(QtGroup as varchar) else 'G'+cast (QtGroup as varchar) end as newintervcall from ( select ResRespondent as Respondent, max(QtGroup) as QtGroup from ( select ResRespondent, QtGroup from quota inner join stratum on strstratum=QtStratum inner join ( select ResRespondent from Respondent where ResCall=0 and (ResIntervCall='' or ResIntervCall='***' or ResIntervCall like 'G[0-9][0-9]') ) a on ResRespondent = strRespondent ) b group by ResRespondent ) c ) d on ResRespondent = Respondent 
update quota set QtUnused=(select count(ResRespondent) from Respondent where ResCall=0),qtfrequence=(select count(ResRespondent) from Respondent where ResCompleted=1) where QtStratum=0
GO

CREATE PROCEDURE [dbo].[sp_AddPhoneToDNCAndRetireRespondent]  @projectId int , @userId int,@ResRespondent varchar(10) AS
set NOCOUNT on

declare @Resphone varchar(20) 
select @Resphone=Resphone from Respondent where ResRespondent=@ResRespondent;

if (@Resphone is not null and @Resphone <> '')
begin
insert into DoNotCallList (phone) values (@Resphone)
declare @DNCResult VarChar(5);								
select @DNCResult = rtrim([value]) from systemConfig where [name]='DoNotCallListResultCode'


insert into historic 
(HisRespondent,HisCallNumber,HisInterviewer,
HisResult,HisCallDate,HisTimeSlot,HisCallDuration,HisDataType,
HisStartQuestion,HisEndQuestion,HisMonitoring,HisDialerLine,HisWait,HisPause,HisFileReference,HisPreviousCallDate,projectId,collectmode)
select @ResRespondent,COALESCE((Select max(HisCallNumber)+1 from historic where hisRespondent=@ResRespondent),1),@userId,@DNCResult,GETUTCDATE(),0,0,0,'','',0,0,0,0,'',(Select max(HisCallDate)from historic where hisRespondent=@ResRespondent),
@projectId,0


update Respondent set ResCallbackDate=0,ResCall=1,ResCallCount=ResCallCount+1,ResCodeResult=@DNCResult,projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE()
where ResRespondent=@ResRespondent

select @DNCRESULT
end
GO

CREATE PROCEDURE dbo.sp_RecomputeStratumAndQuotas @projectId int, 
@userId int 
AS 
GO

CREATE PROCEDURE dbo.sp_RecomputeStratumAndQuotasForImportWave @projectId int, 
@userId int 
,@ImportationWaveNo int 
AS 	
GO

CREATE PROCEDURE dbo.sp_RecomputeStratumAndQuotasRespondent @projectId int,@userId int, @ResRespondent varchar(10) AS 
GO

CREATE  PROCEDURE dbo.sp_UpdateRespondent  
@ProjectId int,
@UserId int,
@CollectMode int,
@ResRespondent varchar(10),
@ResLanguage int,
@ResTimeZone int,
@ResCallbackDate DateTime,
@ResIntervCall varchar(10),
@ResTimeSlot bit,
@ResCallCount int,
@ResLastCallDate datetime,
@ResVersion varchar(10),
@ResPriority int,
@ResCompleted bit,
@ResConfidPhone bit,
@ResSeed float,
@Resphone varchar(20),
@ResCodeResult varchar(2),
@ResWaveNo int,
@ResBlocked bit,
@ResCompPredictive bit,
@ResCall bit,
@ResMonitored bit,
@ResLastCompQuest int,
@ResPreviousCallDate DateTime,
@ResWaveImportNo int
AS


update Respondent set
projectId = @ProjectId,
collectMode = case when @CollectMode <0 then collectMode else @CollectMode end,
modifiedBy = @UserId,
modified = GETUTCDATE(),
ResLanguage = @ResLanguage,
ResTimeZone = @ResTimeZone,
ResCallbackDate = @ResCallbackDate,
ResIntervCall = @ResIntervCall,
ResTimeSlot = @ResTimeSlot,
ResCallCount = @ResCallCount,
ResLastCallDate = @ResLastCallDate,
ResVersion = @ResVersion,
ResPriority = @ResPriority,
ResCompleted = @ResCompleted,
ResConfidPhone = @ResConfidPhone,
ResSeed = @ResSeed,
Resphone = @Resphone,
ResCodeResult = @ResCodeResult,
ResWaveNo = @ResWaveNo,
ResBlocked = @ResBlocked,
ResCompPredictive = @ResCompPredictive,
ResCall = @ResCall,
ResMonitored = @ResMonitored,
ResLastCompQuest = @ResLastCompQuest,
ResPreviousCallDate = @ResPreviousCallDate,
ResWaveImportNo = @ResWaveImportNo
where 
ResRespondent = @ResRespondent

if @@ROWCOUNT = 0
begin
insert into Respondent
(
ResRespondent,
projectId,
collectMode,
modifiedBy,
modified,
ResLanguage,
ResTimeZone,
ResCallbackDate,
ResIntervCall,
ResTimeSlot,
ResCallCount,
ResLastCallDate,
ResVersion,
ResPriority,
ResCompleted,
ResConfidPhone,
ResSeed,
Resphone,
ResCodeResult,
ResWaveNo,
ResBlocked,
ResCompPredictive,
ResCall,
ResMonitored,
ResLastCompQuest,
ResPreviousCallDate,
ResWaveImportNo)
values
(
@ResRespondent,
@ProjectId,
@CollectMode,
@UserId,
GETUTCDATE(),
@ResLanguage,
@ResTimeZone,
@ResCallbackDate,
@ResIntervCall,
@ResTimeSlot,
@ResCallCount,
@ResLastCallDate,
@ResVersion,
@ResPriority,
@ResCompleted,
@ResConfidPhone,
@ResSeed,
@Resphone,
@ResCodeResult,
@ResWaveNo,
@ResBlocked,
@ResCompPredictive,
@ResCall,
@ResMonitored,
@ResLastCompQuest,
@ResPreviousCallDate,
@ResWaveImportNo
)	
end
GO

CREATE PROCEDURE dbo.sp_UpdateRespondentFromBrowse  
	@ProjectId int,
	@UserId int,
	@ResRespondent varchar(10),
	@Resphone varchar(20),
	@ResPin varchar(100),
	@ResTimeZone int,
	@ResCallbackDate DateTime,
	@ResCodeResult varchar(2)
	AS
	update Respondent set
	projectId = @ProjectId,
	modifiedBy = @UserId,
	modified = GETUTCDATE(),
	Resphone = @Resphone,
	ResTimeZone = @ResTimeZone,
	ResCallbackDate = @ResCallbackDate,
	ResCodeResult = @ResCodeResult
	where 
	ResRespondent = @ResRespondent


	if @ResPin is null
		delete from RespondentPin where rspRespondent=@ResRespondent
	else
	begin
		update RespondentPin set rspPin=@ResPin,
		ProjectId = @ProjectId,
		ModifiedBy = @UserId,
		Modified = GETUTCDATE()
		 where rspRespondent=@ResRespondent
		if @@rowcount = 0
			insert into RespondentPin values(@ResRespondent,@resPin,@projectId,@userId,GETUTCDATE())
	end
GO

CREATE PROCEDURE dbo.sp_UpdateRespondentHistory
@ProjectId int, 
@CollectMode int,
@HisRespondent varchar(10), 
@HisCallNumber int, 
@HisInterviewer varchar(10), 
@HisResult varchar(2), 
@HisCallDate DateTime, 
@HisTimeSlot int, 
@HisCallDuration int, 
@HisDataType int, 
@HisStartQuestion varchar(10), 
@HisEndQuestion varchar(10), 
@HisMonitoring bit, 
@HisDialerLine int, 
@HisWait int, 
@HisPause int, 
@HisFileReference varchar(120), 
@HisPreviousCallDate DateTime,
@HisLifeState varchar(2)

AS

update Historic set
HisRespondent = @HisRespondent,
HisCallNumber = @HisCallNumber,
HisInterviewer = @HisInterviewer, 
HisResult = @HisResult,
HisCallDate = @HisCallDate,
HisTimeSlot = @HisTimeSlot,
HisCallDuration = @HisCallDuration,
HisDataType = @HisDataType,
HisStartQuestion = @HisStartQuestion,
HisEndQuestion = @HisEndQuestion,
HisMonitoring = @HisMonitoring,
HisDialerLine = @HisDialerLine,
HisWait = @HisWait,
HisPause = @HisPause,
HisFileReference = @HisFileReference,
HisPreviousCallDate = @HisPreviousCallDate,
HisLifeState = @HisLifeState,
projectId = @projectId,
collectMode = @collectMode
where 
HisRespondent = @HisRespondent and 
HisCallNumber = @HisCallNumber

if @@ROWCOUNT = 0
begin
insert into Historic
(
HisRespondent,
HisCallNumber,
HisInterviewer, 
HisResult,
HisCallDate,
HisTimeSlot,
HisCallDuration,
HisDataType,
HisStartQuestion,
HisEndQuestion,
HisMonitoring,
HisDialerLine,
HisWait,
HisPause,
HisFileReference,
HisPreviousCallDate,
HisLifeState,
projectId,
collectMode
)
values
(
@HisRespondent,
@HisCallNumber,
@HisInterviewer, 
@HisResult,
@HisCallDate,
@HisTimeSlot,
@HisCallDuration,
@HisDataType,
@HisStartQuestion,
@HisEndQuestion,
@HisMonitoring,
@HisDialerLine,
@HisWait,
@HisPause,
@HisFileReference,
@HisPreviousCallDate,
@HisLifeState,
@projectId,
@collectMode
)	
end	
GO

CREATE PROCEDURE dbo.sp_UpdateRespondentNote
@projectId int, 
@UserId int, 
@collectMode int, 
@NotRespondent varchar(10), 
@NotDateTime DateTime, 
@NotInterv varchar(10), 
@NotQuestion varchar(10), 
@NotMatrix int, 
@NotNote nvarchar(500)
AS


update note set
ProjectId = @ProjectId,
CollectMode = @CollectMode,
ModifiedBy = @UserId,
Modified = GETUTCDATE(),
NotQuestion = @NotQuestion, 
NotMatrix = @NotMatrix, 
NotNote = @NotNote
where 
NotRespondent = @NotRespondent and 
NotDateTime = @NotDateTime and 
NotInterv  = @NotInterv

if @@ROWCOUNT = 0
begin
insert into note
(
ProjectId,
CollectMode,
ModifiedBy,
Modified,
NotRespondent,
NotDateTime,
NotInterv,
NotQuestion,
NotMatrix,
NotNote
)
values
(
@ProjectId,
@CollectMode,
@UserId,
GETUTCDATE(),
@NotRespondent, 
@NotDateTime, 
@NotInterv, 
@NotQuestion, 
@NotMatrix, 
@NotNote
)	
end	
GO

CREATE  PROCEDURE dbo.sp_UpdateRespondentResponse
@ProjectId int,
@UserId int,
@CollectMode int,
@RpsRespondent varchar(10),
@RpsQuestion varchar(10),
@RpsMatrix int,
@RpsMention int,
@RpsContent nvarchar(100),
@rpsOpened ntext,
@rpsType int
AS


update Response set
projectId = @ProjectId,
collectMode = case when @CollectMode <0 then collectMode else @CollectMode end,
modifiedBy = @UserId,
modified = GETUTCDATE(),
RpsContent = @RpsContent,
RpsOpened = @rpsOpened
where 
RpsRespondent = @RpsRespondent and
RpsQuestion = @RpsQuestion and
RpsMatrix = @RpsMatrix and
RpsMention = @RpsMention and
RpsType = @RpsType

if @@ROWCOUNT = 0
begin
insert into Response
(
RpsRespondent,
projectId,
collectMode,
modifiedBy,
modified,
RpsQuestion,
RpsMatrix,
RpsMention,
RpsContent,
RpsOpened,
RpsType
)
values
(
@RpsRespondent,
@ProjectId,
@CollectMode,
@UserId,
GETUTCDATE(),
@RpsQuestion,
@RpsMatrix,
@RpsMention,
@RpsContent,
@rpsOpened,
@rpsType
)	
end
GO

CREATE  PROCEDURE dbo.sp_ImportRespondent 
(
@projectId int,
@userId int,
@ResRespondent varchar(10),
@resLanguage int,
@resTimeZone int,
@ResIntervCall varchar(4),
@resConfidPhone bit,
@resPhone varchar(20),
@resPriority int,
@ResWaveImportNo int,
@ExtractTimeZoneFromAreaCode bit,
@CheckPhoneForDuplicate bit
)
AS
	
if @CheckPhoneForDuplicate =1  and @Resphone <> '' and @Resphone is not null
begin
	declare @key varchar(10)
	select @key = ResRespondent from dbo.Respondent where Resphone=@Resphone
	if @key is not null
	begin
		RAISERROR ('VOXCOERROR_1000 Duplicate phone numbers are not allowed.', 16, 1)
		return
	end
end

if @ExtractTimeZoneFromAreaCode =1
begin
declare @AreaCode varchar(3);
set @AreaCode = SUBSTRING(@resPhone, 1, 3)	   
select @resTimeZone = coalesce(TimeZone,0) from dbo.AreaCodeTZ where code=@AreaCode
end

INSERT INTO [dbo].[Respondent] ([ResRespondent],[ResLanguage],[ResTimeZone],[ResCallbackDate],[ResIntervCall],[ResTimeSlot],[ResCallCount],[ResLastCallDate],[ResVersion],[ResPriority],[ResCompleted],[ResConfidPhone],[ResSeed],[Resphone],[ResCodeResult],[ResWaveNo],[ResBlocked],[ResCompPredictive],[ResCall],[ResMonitored],[ResLastCompQuest],[ResPreviousCallDate],[ResWaveImportNo],[projectId],[modifiedBy],[modified],[collectMode])
     VALUES(
	@ResRespondent,
	@resLanguage,
	@resTimeZone,
	0,
	@ResIntervCall,
	0,
	0,
	null,
	null,
	@resPriority,
	0,
	@resConfidPhone,
	@ResRespondent,
	@resPhone,
	null,
	0,
	0,
	0,
	0,
	0,
	0,
	null,
	@ResWaveImportNo,
	@projectId,
	@userId,
	GETUTCDATE(),
	0			
	)	

if @ExtractTimeZoneFromAreaCode =1
begin
	exec sp_UpdateRespondentResponse @projectId,@userId,0,@ResRespondent,'TZONE',1,1,@resTimeZone,'',0
end
GO


CREATE PROCEDURE dbo.sp_Select_With_Paging (
	@strFields VARCHAR(4000) ,
	@strPK VARCHAR(100),
	@strTables VARCHAR(8000),
	@intPageNo INT = 1,
	@intPageSize INT = NULL,
	@blnGetRecordCount BIT = 0,
	@strFilter VARCHAR(8000) = NULL,
	@strSort VARCHAR(8000) = NULL,
	@strGroup VARCHAR(8000) = NULL
)

/*
	PURPOSE: executes a select statement as defined by the parameters and returns a particular page of data (or all rows) efficiently
	AUTHOR: Andrew Rosca (arosca@machrotech.com)
	(c)2002 Andrew Rosca. You may use and distribute this code freely under the GNU licensing standard.
*/

 AS
	DECLARE @blnBringAllRecords BIT
	DECLARE @strPageNo VARCHAR(50)
	DECLARE @strPageSize VARCHAR(50)
	DECLARE @strSkippedRows VARCHAR(50)

	DECLARE @strFilterCriteria VARCHAR(8000)
	DECLARE @strSimpleFilter VARCHAR(8000)
	DECLARE @strSortCriteria VARCHAR(8000)
	DECLARE @strGroupCriteria VARCHAR(8000)

	DECLARE @intRecordcount INT
	DECLARE @intPagecount INT	


--******** NORMALIZE THE PAGING CRITERIA
	--if no meaningful inputs are provided, we can avoid paging and execute a more efficient query, so we will set a flag that will help with that (blnBringAllRecords)

	IF @intPageNo < 1
		SET @intPageNo = 1

	SET @strPageNo = CONVERT(VARCHAR(50), @intPageNo)
	
	IF @intPageSize IS NULL OR @intPageSize < 1 -- BRING ALL RECORDS, DON'T DO PAGING
		SET @blnBringAllRecords = 1
	ELSE
		BEGIN
			SET @blnBringAllRecords = 0
			SET @strPageSize = CONVERT(VARCHAR(50), @intPageSize)
			SET @strPageNo =  CONVERT(VARCHAR(50), @intPageNo)
			SET @strSkippedRows = CONVERT(VARCHAR(50), @intPageSize * (@intPageNo - 1))
		END





--******** NORMALIZE THE FILTER AND SORTING CRITERIA
	--if they are empty, we will avoid filtering and sorting, respectively, executing more efficient queries

	IF @strFilter IS NOT NULL AND @strFilter != '' 
		BEGIN
			SET @strFilterCriteria = ' WHERE ' + @strFilter + ' '
			SET @strSimpleFilter = ' AND ' + @strFilter + ' '
		END
	ELSE
		BEGIN
			SET @strSimpleFilter = ''
			SET @strFilterCriteria = ''
		END

	IF @strSort IS NOT NULL AND @strSort != '' 
		SET @strSortCriteria = ' ORDER BY ' + @strSort + ' '
	ELSE
		SET @strSortCriteria = ''

	IF @strGroup IS NOT NULL AND @strGroup != '' 
		SET @strGroupCriteria = ' GROUP BY ' + @strGroup + ' '
	ELSE
		SET @strGroupCriteria = ''



--************************** NOW START DOING THE REAL WORK

IF @blnBringAllRecords = 1 --ignore paging and run a simple select
BEGIN

	EXEC (
		'SELECT ' + @strFields + ' FROM ' + @strTables + @strFilterCriteria + @strGroupCriteria + @strSortCriteria
	)

END-- WE HAD TO BRING ALL RECORDS
ELSE		--BRING ONLY A PARTICULAR PAGE
BEGIN
	IF @intPageNo = 1 --in this case we can execute a more efficient query, with no subqueries
		EXEC (
			'SELECT TOP ' + @strPageSize + ' ' + @strFields + ' FROM ' + @strTables + @strFilterCriteria + @strGroupCriteria + @strSortCriteria
		)
	ELSE --execute a structure of subqueries that brings the correct page
		EXEC (
			'SELECT ' + @strFields + ' FROM ' + @strTables + ' WHERE ' + @strPK + ' in ' + '
				(SELECT TOP ' + @strPageSize + ' ' + @strPK + ' FROM ' + @strTables + 
					' WHERE ' + @strPK + ' NOT in ' + '
						(SELECT TOP ' + @strSkippedRows + ' ' + @strPK + ' FROM ' + @strTables + @strFilterCriteria + @strGroupCriteria + @strSortCriteria + ') ' +
					@strSimpleFilter +
					@strGroupCriteria +
					@strSortCriteria + ') ' +
				@strGroupCriteria +
				@strSortCriteria
		)

END --WE HAD TO BRING A PARTICULAR PAGE


--IF WE NEED TO RETURN THE RECORDCOUNT
IF @blnGetRecordCount = 1
	IF @strGroupCriteria != ''
		EXEC (
			'SELECT COUNT(*) AS RECORDCOUNT FROM (SELECT COUNT(*) FROM ' + @strTables + @strFilterCriteria + @strGroupCriteria + ') AS tbl (id)'
		)
	ELSE
		EXEC (
			'SELECT COUNT(*) AS RECORDCOUNT FROM ' + @strTables + @strFilterCriteria + @strGroupCriteria
		)				
GO

CREATE FUNCTION dbo.GetFirstLanguageCode
(@questionnaireId int)  
RETURNS varchar(2)  AS  
BEGIN 
declare @code varchar(80)
select @code=code 
from questioncode 
where questionnaire= @questionnaireId
and alias='LANG' and position=1 
if @code is null or @code='' 
set  @code= '01' 

return @code
END
GO

CREATE FUNCTION dbo.GetAgentName (@AgentId varchar(10))
RETURNS  varchar(100)
AS  
BEGIN
declare @result varchar(100)	
select @result = coalesce((select name from tblobjects_view where convert(varchar,k_id)=@AgentId),@AgentId)
Return @result
END		
GO

CREATE FUNCTION dbo.TimeSlotNumber  (@DateHour  DateTime)
RETURNS  int  
AS  
BEGIN
declare @HR float
Declare @WD int
Declare @NTS int
Set @NTS=0
Set @WD=DatePart(dw,@DateHour)
Set @HR=(DatePart(hh,@DateHour)*60)+DatePart(n,@DateHour)
Declare CursorTSLN Cursor for
select TslTimeSlot from TimeSlot  Where ( @WD= TslWeekDay) 
and 
(@HR >= ((DatePart(hh,TslStartTime)*60)+DatePart(n,TslStartTime)))
and
(@HR<((DatePart(hh,TslEndTime)*60)+DatePart(n,TslEndTime))
)
open CursorTSLN
Fetch next from CursorTSLN  into @NTS
close  CursorTSLN
deallocate  CursorTSLN
Return @NTS
END						
GO

CREATE FUNCTION dbo.ConvertToFloat(@Val  varchar(100))
RETURNS  float  
AS  
BEGIN

declare @res float

DECLARE @position int
declare @vallen int
set @val = ltrim(rtrim(@val))
set @vallen = len(@val)

-- Initialize the variables.
SET @position = 1
WHILE @position <= @vallen
BEGIN
	if SUBSTRING(@val, @position, 1) not in ('0','1','2','3','4','5','6','7','8','9','.','-')
	begin
		set @val=''		
		break
	end
	else
		SET @position = @position + 1
END

if isnumeric(@val)=0 or @val='-'
begin
	if @val is null	
	set @res=0
	else
	if @val = ''
	set @res=0
	else
	set @res=null
end
else
begin
	if @val='.'
	set @res=null
	else
	set @res = cast(@val as float)
end


return @res	
END
GO

CREATE TRIGGER TRUPDATE_QUOTA ON Quota
FOR  Update  AS
IF Update(QtStatus)
begin
Select * from deleted De,inserted ins where 
(ins.QtStratum=De.QtStratum) and (ins.QtStatus<>De.QtStatus) and (ins.QtStatus=2)



if @@ROWCOUNT >0   
begin   
  Delete From dbo.bufferNew 
end
end
GO
						
					

CREATE PROCEDURE dbo.sp_ResetRespondent  
				@projectId int,
				@Respondent varchar(10),
				@UserId  int
				AS

				delete from Response where 
				RpsQuestion not in (select ifquestion from importedfields) 
				and
				RpsRespondent=@Respondent

				delete from note
				where NotRespondent=@Respondent

				declare @callNumber int
				select @callNumber = coalesce(max(HisCallNumber),0) +1 from Historic where HisRespondent=@Respondent

				insert into Historic 
				(
				HisRespondent,
				HisCallNumber,
				HisInterviewer,
				HisResult,
				HisCallDate,
				HisCallDuration,
				HisWait,
				HisPause,
				projectId,
				collectMode				
				)

				values
				(
				@Respondent,
				@callNumber,
				@UserId,
				'RS',
				GETUTCDATE(),
				0,
				0,
				0,
				@projectId,	
				0
				)

				declare @iscompleted bit
				select @iscompleted=ResCompleted from Respondent 
				where ResRespondent=@Respondent

				update Respondent set ResCompleted=0,ResCall=0,ResLastCompQuest=0,ResCallCount=@callNumber,
				projectId=@projectId,modifiedBy=@userId,modified=GETUTCDATE()
				where ResRespondent=@Respondent
				select top 1 * from Respondent

				if @iscompleted=1 
				begin
				exec sp_RespondentIncDecQuota @projectId,@userId,@Respondent,0
				end
GO

INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'PRIORITY OF FRESH' ,'RULES' ,'0' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'MAX WAVES' ,'RULES' ,'0' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'INITIAL SUP' ,'PROJECT' ,'SUP' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'REVIEW OPEN ENDS' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'PERMANENT MESSAGE' ,'OPTIONS' ,'$Q $N' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DISPLAY ALIAS' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'CONFIRM ENTRY' ,'OPTIONS' ,'0' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'ALLOWED BACKWARDS JUMPS' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DisableNextNavigationOnBrowse' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'ALLOW REVIEW' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'ALLOW LOWER CASE IN OPENEND' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'ADD INTERVIWER' ,'OPTIONS' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'PERMANENT MESSAGE' ,'MESSAGES' ,'Questionnaire ID:$Q            Phone:$N' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'QUESTIONNAIRE PATH' ,'FILES' ,'' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY7' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY6' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY5' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY4' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY3' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY2' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
INSERT INTO Installation ( INSIDENT ,INSSECTION ,INSVALUE ,modified ,modifiedBy ,projectId  ) VALUES ( 'DAY1' ,'CALENDAR' ,'1' ,GetUTCDate() ,0 ,#ProjectID# ) 
GO


--------------------------------------------
-- Create View based on VoxcoSystem END
-- 
-- IMPORTANT : MUST BE THE LAST STATEMENT OF THE SCRIPT
-- IN CASE VoxcoSystemDatabaseName does not exists.
--------------------------------------------

--------------------------------------------
-- Create View based on VoxcoSystem
-- 
-- IMPORTANT : MUST BE THE LAST STATEMENT OF THE SCRIPT
-- IN CASE VoxcoSystemDatabaseName does not exists.
--------------------------------------------
create view dbo.TimeZones as select * from #VoxcoSystemDatabaseName#.dbo.TimeZones 
GO

create view dbo.AreaCodeTZ as select * from #VoxcoSystemDatabaseName#.dbo.AreaCodeTZ
GO

create view dbo.SystemConfig as select * from #VoxcoSystemDatabaseName#.dbo.SystemConfig
GO

create view dbo.DoNotCallList as select * from #VoxcoSystemDatabaseName#.dbo.DoNotCallList
GO

create view dbo.Question as select * from #VoxcoSystemDatabaseName#.dbo.Question
GO

create view dbo.QuestionCode as select * from #VoxcoSystemDatabaseName#.dbo.QuestionCode
GO

create view dbo.Label as select * from #VoxcoSystemDatabaseName#.dbo.Label
GO

create view dbo.LabelContent as select * from #VoxcoSystemDatabaseName#.dbo.LabelContent
GO

create view dbo.tblAgents_View as select * from #VoxcoSystemDatabaseName#.dbo.tblAgents
GO

create view dbo.tblObjects_View as select * from #VoxcoSystemDatabaseName#.dbo.tblObjects
GO

create view dbo.tblAgents as select * from #VoxcoSystemDatabaseName#.dbo.tblAgents
GO

create view dbo.tblObjects as select * from #VoxcoSystemDatabaseName#.dbo.tblObjects
GO

create view dbo.tblPages as select * from #VoxcoSystemDatabaseName#.dbo.tblPages
GO


--------------------------------------------
-- Create View based on VoxcoSystem END
-- 
-- IMPORTANT : MUST BE THE LAST STATEMENT OF THE SCRIPT
-- IN CASE VoxcoSystemDatabaseName does not exists.
--------------------------------------------


-- ==========================================================
--
-- FGetSundayDate
-- Function qui retourne la date du n Dimanche du mois
-- @sundayindex at 5 veux dire le dernier dimanche du mois 
-- Avantage: Cette version n'utilise pas de table temporaire
-- ==========================================================
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FGetSundayDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FGetSundayDate]
GO
CREATE Function [dbo].[FGetSundayDate] 
(
	@year int,  -- The Year
	@month int, -- The Month
	@sundayindex int --Sunday Index 1, 2, 3, 4 and 5 for the latest 
)
returns DateTime
AS
BEGIN
	-- new version september 2013
	-- Country datefirst mod
	declare @lastSundaydatefirstMod int
	declare @firstNSundaydatefirstMod int
	if ( @@datefirst = 1 )
	begin
		set @lastSundaydatefirstMod = 0
		set @firstNSundaydatefirstMod = 7
	end
	else
	begin
		set @lastSundaydatefirstMod = 1
		set @firstNSundaydatefirstMod = 8
	end

	declare @thedate DateTime
	set @thedate  = DATEADD(yyyy,@year-DATEPART(yyyy,GETDATE()),GETDATE()) 
	set @thedate = DATEADD(mm,@month-DATEPART(mm,@TheDate),@TheDate) 

	declare @firstSunday datetime
	declare @returnSunday datetime

	declare @lastdayofmonth datetime
	declare @firstdayofmonth datetime
	set @firstdayofmonth = DATEADD(dd,1-DAY(@thedate),@thedate)
	set @lastdayofmonth = DATEADD(mm,1,@firstdayofmonth) - 1

	declare @dayofweek int -- 1 sunday , 6 

	if ( @sundayindex < 5 )
	begin
		-- find the first n sunday
		set @dayofweek = DATEPART(dw,@firstdayofmonth);
		if ( @dayofweek = 8-@@datefirst )
			set @firstSunday = @firstdayofmonth
		else
			set @firstSunday = DATEADD(dd,@firstNSundaydatefirstMod-@dayofweek,@firstdayofmonth)

		set @returnSunday = DATEADD(dd,(@sundayindex-1)*7,@firstSunday)
	end
	else
	begin
		-- find the last sunday of the month
		set @dayofweek = DATEPART(dw,@lastdayofmonth);
		if ( @dayofweek =  8-@@datefirst )
			set @returnSunday = @lastdayofmonth
		else
			set @returnSunday = DATEADD(dd,@lastSundaydatefirstMod-@dayofweek,@lastdayofmonth)
	end
	RETURN @returnSunday
END

GO

-- ************************************************
--
-- FROM UTC
--
-- ************************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_FromUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_FromUTC]
GO
CREATE FUNCTION [dbo].[VX_fn_FromUTC]
(
	@sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
	-- new version september 2013
	--return the converted time base on timeZoneBias and DST of the source date
	declare @newdt datetime

	if ( @sourceDateTime > 2 )
	begin 

		-- Declare the return variable here
		declare @gmtbias float
		declare @dstbias float
		declare @stdmonth int
		declare @stdday int
		declare @dstmonth int
		declare @dstday int
		declare @dstactive bit
		
		declare @stddate DateTime
		declare @dstdate DateTime
		declare @sourceDateYear int

		SELECT	@gmtbias = gmtbias,
				@dstbias = dstbias,
				@dstactive = dstactive,
				@stdmonth = standardmonth,
				@stdday = standardday,
				@dstmonth = dstmonth,
				@dstday = dstday
		FROM TimeZones where id = @timeZoneId



		--Get the year of the source date
		set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
		
		--Get StandardTime  Starting date
		set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
		
		--Get Dst Time Starting date
		set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


		declare @isSourceDateDst bit
		set @isSourceDateDst = 0

		-- Determine wich one come first in the year Standard Time
		if ( @dstbias > 0 )
		begin
			if (  @stddate > @dstdate )
			begin
				if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
				begin
					set @isSourceDateDst = 1
				end
			end
			else
			begin
				if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
				begin
					set @isSourceDateDst = 0
				end
				else
				begin
					set @isSourceDateDst = 1
				end
			end
		end
		
		if ( @isSourceDateDst = 1 )
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
			set @newdt = DateAdd(mi,@dstbias*60,@newdt)
		 end
		else
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
		 end

	end
	else
	begin  -- @sourceDateTime < 2, we do not convert these date, they are flag date
		set @newdt = @sourceDateTime;
	end

	-- Return the result of the function
	RETURN @newdt

END
GO


-- ************************************************
--
-- TO UTC
--
-- ************************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_ToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_ToUTC]
GO
CREATE FUNCTION [dbo].[VX_fn_ToUTC]
(
	@sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
	-- new version september 2013
	--return the converted time base on timeZoneBias and DST of the source date
	declare @newdt datetime	

	if ( @sourceDateTime > 2 )
	begin
		-- Declare the return variable here
		declare @gmtbias float
		declare @dstbias float
		declare @stdmonth int
		declare @stdday int
		declare @dstmonth int
		declare @dstday int
		declare @dstactive bit
		
		declare @stddate DateTime
		declare @dstdate DateTime
		declare @sourceDateYear int

		SELECT	@gmtbias = gmtbias,
				@dstbias = dstbias,
				@dstactive = dstactive,
				@stdmonth = standardmonth,
				@stdday = standardday,
				@dstmonth = dstmonth,
				@dstday = dstday
		FROM TimeZones where id = @timeZoneId

		--Get the year of the source date
		set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
		
		--Get StandardTime  Starting date
		set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
		
		--Get Dst Time Starting date
		set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


		declare @isSourceDateDst bit
		set @isSourceDateDst = 0

		-- Determine wich one come first in the year Standard Time
		if ( @dstbias > 0 )
		begin
			if (  @stddate > @dstdate )
			begin
				if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
				begin
					set @isSourceDateDst = 1
				end
			end
			else
			begin
				if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
				begin
					set @isSourceDateDst = 0
				end
				else
				begin
					set @isSourceDateDst = 1
				end
			end
		end

		--invert bias for "TO UTC"
		set @gmtbias = 0 - @gmtbias	
		set @dstbias = 0 - @dstbias

		if ( @isSourceDateDst = 1 )
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
			set @newdt = DateAdd(mi,@dstbias*60,@newdt)
		 end
		else
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
		 end

	end
	else
	begin  -- @sourceDateTime < 2, we do not convert these date, they are flag date
		set @newdt = @sourceDateTime;
	end

	-- Return the result of the function
	RETURN @newdt
END
GO


/* New function for splitting string */

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_cte_SplitString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	drop function [dbo].[fn_cte_SplitString]
GO

CREATE FUNCTION [dbo].[fn_cte_SplitString] (
	@csv nvarchar(MAX),
	@sep nchar(1) = ',' 
) RETURNS TABLE 
AS
	RETURN
	WITH csvtbl(start, stop) AS (
		SELECT start = convert(bigint, 1),
				stop = charindex(@sep,
					@csv + convert(nvarchar(MAX), @sep))
	UNION ALL
	SELECT start = stop + 1,
		stop = charindex(@sep,
			@csv + convert(nvarchar(MAX), @sep), stop + 1)
	FROM   csvtbl
	WHERE  stop > 0
	)
	SELECT ltrim(rtrim(convert(nvarchar(4000),
		substring(@csv, start,
			CASE WHEN stop > 0 THEN stop - start ELSE 0 END)
		))) AS Value
	FROM   csvtbl
	WHERE  stop > 0
GO